package gov.va.genisis2Test.exceptions;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.exceptions.Genisis2RestException;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;

/**
 * 
 * @author1 Janet Lopez
 * 
 * The Class Genisis2RestExceptionTest.
 * 
 * Description: In this Genisis2RestExceptionTest Class which extends the abstract
 * class, AbstractMockMvcTests, junit tests are defined.
 */
public class Genisis2RestExceptionTest extends AbstractMockMvcTests {
	
	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(Genisis2RestExceptionTest.class);

	/**
	 * Test genisis 2 rest exception.
	 */
	@Test
	public void TestGenisis2RestException() {
		logger.info("**********Junit Test Genisis2 Rest Exception**********");
		Genisis2RestException genisis2RestException = new Genisis2RestException(null);
		Assert.assertNull(genisis2RestException.getErrorMessage());
		Assert.assertNull(genisis2RestException.getMessage());

		genisis2RestException = new Genisis2RestException("errorMessageTestOne");
		Assert.assertEquals("errorMessageTestOne", genisis2RestException.getErrorMessage());

		logger.info("**********End of Junit Test Genisis2 Rest Exception**********");
	}
}
